#ifndef __ERRORS_H__
#define __ERRORS_H__

#include "dm_errors.h"

INT32 ErrorLogLock(void);
void ErrorLogUnlock(void);

// We don't have a lot of RAM to save lots of error log entries!
typedef struct
{
    UINT32 timestamp;
//    char taskName[4];
    UINT8 level;
    UINT8 subsystem;
    UINT8 errCode;
    UINT16 causeCode;
    BOOL reported;
    //char msg[20];
}ERRORLOGENTRY;

typedef struct
{
    UINT8 OldestEntry;
    UINT8 errCnt;
    UINT8 LogSize;
    ERRORLOGENTRY *pFirstEntry;
    char fatalMsg[40];
}ERRORLOG;


extern ERRORLOG ErrorLog;

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
}
#endif

#endif  //__ERRORS_H__

